%define module_name Test-Applify
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Applify.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/String.pm) perl(Test/More.pm) perl(Test/Synopsis.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Testing Applify scripts
Group: Development/Perl
License: artistic_2
URL: https://github.com/kiwiroy/perl5-Test-Applify

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KI/KIWIROY/tmp/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Test::Applify manpage is a test agent to be used with the Test::More manpage to test
the Applify manpage scripts. To run your tests use the prove manpage.

  $ prove -l -v t

Avoid testing the Applify code for correctness, it has its own test suite.
Instead, test for consistency of option behaviour, defaults and requiredness,
the script is compiled and that attributes and methods of the script behave with
different inputs.

The aim is to remove repetition of multiple blocks to retrieve instances and
checks for success of `do'.

  my $app = do 'bin/app.pl'; ## check $@ and return value
  {
    local @ARGV = qw{...};
    my $instance = $app->_script->app;
    # more tests.
  }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
