Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-AutoLoader
Version:        0.03
Release:        alt3_38
Summary:        Testing utility for autosplit/autoloaded modules
License:        GPL-1.0-or-later
URL:            https://metacpan.org/release/Test-AutoLoader
Source0:        https://cpan.metacpan.org/authors/id/B/BW/BWARFIELD/NRGN/Test-AutoLoader-%{version}.tar.gz
# Fix test plan number (RT#66399)
Patch0:         Test-AutoLoader-0.03-Fix-test-plan-number.patch
# Perl 5.16 does not autosplit POSIX module (RT#77942)
Patch1:         Test-AutoLoader-0.03-Skip-POSIX-tests-with-perl-5.16.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Test/Builder.pm)
# Tests:
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Tester.pm)
Source44: import.info

%description
This single-purpose module attempts to eliminate uncaught syntax errors or
other obvious goofs in subroutines that are autosplit, and hence not looked
at by perl -c Module.pm. Ideally, this module will become unnecessary as
you reach full coverage of those subroutines in your unit tests. Until that
happy day, however, this should provide a quick and dirty backstop for
embarrassing typos.

%prep
%setup -q -n Test-AutoLoader-%{version}
%patch0  -p1
%patch1  -p1

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
# Tests expect non-localized messages (RT#62839)
LC_ALL=C make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
