%define module_name Test-BDD-Cucumber-Definitions
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Const/Fast.pm) perl(DBI.pm) perl(Data/Printer.pm) perl(Exporter.pm) perl(File/Slurper.pm) perl(File/Spec/Functions.pm) perl(HTTP/Response.pm) perl(HTTP/Tiny.pm) perl(Hash/MultiValue.pm) perl(IO/Capture.pm) perl(IO/String.pm) perl(IPC/Run3.pm) perl(JSON/Path.pm) perl(JSON/XS.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Moose.pm) perl(Params/ValidationCompiler.pm) perl(Test/BDD/Cucumber.pm) perl(Test/Compile.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/PerlTidy.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.41
Release: alt1
Summary: a collection of step definitions for Test Driven Development
Group: Development/Perl
License: perl
URL: https://github.com/ivanych/Test-BDD-Cucumber-Definitions

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IV/IVANYCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In file features/step_definitions/http_steps.pl:

    #!/usr/bin/perl

    use strict;
    use warnings;

    use Test::BDD::Cucumber::Definitions::HTTP::In;

In file features/http.feature:

    Feature: HTTP
        Site test by HTTP

    Scenario: Loading the page
        When http request "GET" send "http://metacpan.org"
        Then http response code eq "200"

... and, finally, in the terminal:

    $ pherkin

      HTTP
        Site test by HTTP

        Scenario: Loading the page
          When http request "GET" send "http://metacpan.org"
          Then http response code eq "200"

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/T*

%changelog
