%define module_name Test-Builder-SubtestSelection
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(Test/Builder/Tester.pm) perl(Test/More.pm) perl(lib.pm) perl(parent.pm) perl(subs.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001003
Release: alt1
Summary: Select subtests by name or by number
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SV/SVW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Modern Perl blog entries referred to in the the section on "SEE ALSO" section
describe how usual Perl functions can be used to group related test function
calls inside a test script. By convention the name of each such a grouping
function should start with the `test_' prefix. If the groups of test function
calls are independent within the test script, which is anyway a good test
discipline, it should be possible to run them individually. The the Test::Named manpage
module supports this approach.

This `Test::Builder::SubtestSelection' class is a subclass of the Test::Builder manpage
that overrides its `subtest()' method. It assumes that the Test::Builder manpage
subtests are used to group related test function calls inside a test
script. The class allows you to select subtests by name or by number to
run them. The name of a subtest is more like a description. Any string is
allowed and no special naming convention needs to be followed. If possible
each string is treated as a regular expression; otherwise meta characters
are properly quoted. The selection process itself applies to top-level
(not nested) subtests only! The selection criteria (name or number) is the
value of either the short `-s' or long `--subtest' option that have to
be supplied together as arguments to the test script. To do so separate the
arguments from prove's own arguments with the arisdottle (`::'). Example:

  # run all subtests
  prove -v -b t/basic.t
  # run "this"
  prove -v -b t/basic.t :: -s 1
  # run "or that"
  prove -v -b t/basic.t :: --subtest 'or that'

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
