# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Classy
%define upstream_version 0.11

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Write your unit tests in other modules than *.t
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Data/Inheritable.pm)
BuildRequires: perl(Class/Inspector.pm)
BuildRequires: perl(Data/Dump.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Module/Find.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Term/Encoding.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/UseAllModules.pm)
BuildArch:  noarch
Source44: import.info

%description
This is yet another the Test::Class manpage-like unit testing framework. As
stated in the Test::Class manpage pod, you don't need to care if your tests
are small and working correctly. If not, this may be one of your options.

Unlike the Test::Class manpage, Test::Classy (actually Test::Classy::Base)
is based on the Test::More manpage and exports everything the Test::More
manpage exports. Test::Classy doesn't control test flow as fully as the
Test::Class manpage, but it may be easier to skip and limit tests.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*

%changelog
