# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Test-Compiles
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: tests if perl can compile a string of code
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Test-Compiles

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Test::Compiles exports two functions to allow you to check whether a
string of code can be compiled by perl without errors. It doesn't check
whether it can be *executed*.

Note that Perl code can execute arbitrary instructions as part of its
compilation (e.g. in a `BEGIN { ... }' block), so don't pass
untrusted strings to these test functions.

=over

=item `compiles $code, $message, %%options'

=item `compiles $code, %%options'

=item `compiles $code, $message'

=item `compiles $code'

This test passes if `$code' can be compiled.

Valid options are:

=over

=item * `strict': boolean to indicate whether code should be compiled
with `use strict'. Enabled by default.

=item * `warnings': boolean to indicate whether code should be
compiled with `use warnings FATAL => 'all''. Disabled by default.

=item * `package': package that the code should be compiled in.
Defaults to the caller.

=item * `prelude': a string of Perl code to prepend to `$code'.
Defaults to `$Test::Compiles::PRELUDE', which is (by default) an
empty string.

=item * `message': an alternative to specifying `$message'.

=back

=item `doesnt_compile $code, $message, %%options'

=item `doesnt_compile $code, %%options'

=item `doesnt_compile $code, $message'

=item `doesnt_compile $code'

This test passes if `$code' cannot be compiled. It accepts the
same options.

=back

This module defines a package variable `$Test::Compiles::PRELUDE'
which can be used to, for example, load pragmata like the indirect manpage or
the bareword::filehandles manpage.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README CREDITS LICENSE COPYRIGHT
%perl_vendor_privlib/T*

%changelog
