# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Corpus-Audio-MPD
%define upstream_version 1.120990

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Automate launching of fake mdp for testing purposes
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/ShareDir.pm)
BuildRequires: perl(File/ShareDir/PathClass.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Readonly.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module will try to launch a new mpd server for testing purposes. This
mpd server will then be used during POE::Component::Client::MPD
or Audio::MPD tests.

In order to achieve this, the module will create a fake _mpd.conf_ file
with the correct paths (ie, where you untarred the module tarball). It
will then check if some mpd server is already running, and stop it if the
'MPD_TEST_OVERRIDE' environment variable is true (die otherwise). Last it
will run the test mpd with its newly created configuration file.

Everything described above is done automatically when the module is
'use'-d.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*


%changelog
