%define module_name Test-Cukes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp/Assert.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build/Tiny.pm) perl(Moose.pm) perl(Test/Builder/Module.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: A BBD test tool inspired by Cucumber
Group: Development/Perl
License: mit
URL: https://github.com/gugod/Test-Cukes

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Test::Cukes is a testing tool inspired by Cucumber
(http://cukes.info). It lets your write your module test with
scenarios. It may be used with the Test::More manpage or other family of
TAP `Test::*' modules. It uses the Test::Builder::note manpage function
internally to print messages.

This module implements the Given-When-Then clause only in English. To
uses it in the test programs, feed the feature text into `feature'
function, defines your step handlers, and then run all the tests by
calling `runtests'. Step handlers may be defined in separate modules,
as long as those modules are included before `runtests' is called.
Each step may use either `assert' or standard TAP functions such as
`Test::Simple''s `ok' or `Test::More''s `is' to verify desired
result.  If you specify a plan explicitly, you should be aware that
each step line in your scenario runs an additional test, and will
therefore add to the number of tests you must indicate.

If any assertion in the Given block failed, the following `When' and
`Then' blocks are all skipped.

You don't need to specify the number of tests with `plan'. Each step
block itself is simply one test. If the block died, it's then
considered failed. Otherwise it's considered as passing.

In the call to the Test::Cukes::runtests manpage, the done_testing manpage will automatically
be called for you if you didn't specify a plan.

Test::Cukes re-exports `assert' function from `Carp::Assert' for you
to use in the step block.

For more info about how to define feature and scenarios, please read
the documents from http://cukes.info.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/T*

%changelog
