%define module_name Test-DBIx-Class-Stats
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(DBIx/Class.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moo.pm) perl(MooX/HandlesVia.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Test/Builder.pm) perl(Test/DBIx/Class.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(YAML/Tiny.pm) perl(parent.pm) perl(Data/Perl/Role/Collection/Array.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: test statistics about your DBIx::Class calls
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABRAXXA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Run a subtest with a debugging object (the Test::DBIx::Class::Stats::Profiler manpage) set to capture
the number of calls that have been made to the database. This may be useful to
check your assumptions about prefetching, etc.

    use Test::More;
    use Test::DBIx::Class::Stats;

    # if you are using Test::DBIx::Class or similar, we can get the 
    # database handle from the `Schema` method
    use Test::DBIx::Class;

    with_stats 'test 1', sub {
        my $stats = shift;

        my $rs = Schema->resultset('Foo')->search();
        is $stats->call_count, 0, 'No calls on preparing RS';

        my @foo = $rs->all;
        is $stats->call_count, 1, '1 call after preparing RS';
    };

    # alternatively, we can pass it in explicitly:
    
    my $db = Schema
    with_stats 'test 2', $db, sub {
        ...
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README README.pod Changes
%perl_vendor_privlib/T*

%changelog
