# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Test-DeepMock
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.4
Release: alt1
Summary: Awesome abstract factory class to mock everything for unit tests.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RA/RADIOMKOR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Test::DeepMock is a abstract mock factory which injects mocks in @INC so
whenever your app "requires" the package the mock will be loaded.
Extreemly usefull for testing old legacy code.

Create your factory of mocks:

    package My::Factory;
    use Test::DeepMock ();

    our @ISA = qw( Test::DeepMock );
    our @CONFIG = {
        'My::Package' => {
            source => 'package My::Package; 1;'
        },
        'My::Another::Package' => {
            file_handle => $FH
        },
        'My::Package::From::File' => {
            path => '/some/path/to/mock'
        },
        default => sub {
            my ($class, $package_name) = @_;
            #returns scalar with source of package or file handle
            #return undef to interrupt mocking
        },
    };

In the test: import packages that you want to mock from your factory:

    use My::Factory qw(
        My::Package
        My::Another::Package
        My::Package::From::File
        This::Package::Will::Triger::Default::Subroutine
    );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
