# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find/Rule.pm) perl(File/Spec/Functions.pm) perl(File/stat.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Test-File-Cleaner
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Automatically clean up your filesystem after tests
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
When writing file-related testing code, it is common to end up with a number
of files scattered all over the testing directories. If you are running the
test scripts over and over these leftover files can interfere with subsequent
test runs, and so they need to be cleaned up.

This clean up code typically needs to be done at END-time, so that the files
are cleaned up even if you break out of the test script while it is running.
The code to do this can get long and is labourious to maintain.

Test::File::Cleaner attempts to solve this problem. When you create a
Cleaner object for a particular directory, the object scans and saves the
contents of the directory.

When the object is DESTROYed, it compares the current state to the original,
and removes any new files and directories created during the testing process.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
