# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(JSON/PP.pm) perl(Test/CPAN/Changes.pm) perl(Test/More.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Test-Format
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.0
Release: alt1
Summary: test files if they match format
Group: Development/Perl
License: perl
URL: https://github.com/bessarabov/Test-Format

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BE/BESSARABV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In t/format.t file:

    use strict;
    use warnings FATAL => 'all';

    use Test::More tests => 1;
    use Test::Format;

    test_format(
        files => [
            'data/countries.json',
        ],
        format => 'pretty_json',
    );

It will check file 'data/countries.json' that it is in pretty json format.

And you can prettify all the files that test checks if you run test with
SELF_UPDATE environment variable:

    SELF_UPDATE=1 prove t/format.t

You can also write custom format checker:

    test_format(
        files => [
            'data/file.asdf',
        ],
        format_sub => sub {
            my ($content) = @_;

            # Your custom code that creates pretty $expected_content from ugly $content

            return $expected_content;
        },
    );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/T*

%changelog
