# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Deparse.pm) perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IPC/Open3.pm) perl(Test/Builder/Module.pm) perl(parent.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.3.1
%define module_name Test-Given
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.1
Release: alt1
Summary: Given/When/Then style testing for Perl.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROVJUVANO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Given/When/Then style of testing inspired by rspec-given and jasmine-given.

Example:

    # t/example.t
    use Test::Given;
    use strict;
    use warnings;

    use Subject;

    # or no strict 'vars';
    our ($subject, $result);

    describe 'Subject Under Test' => sub {
      Given subject => sub { Subject->new() };

      When result => sub { $subject->state() };

      Invariant sub { defined $subject };

      Then sub { $result eq 'uninitialized' };

      context 'When used' => {
        Given sub { $subject->init() };

        When sub { $subject->use() };
        And result => sub { $subject->state() };

        Then sub { $result eq 'passed' };
        And sub { $result ne 'failed' };

        context 'and re-used' => sub {
          When sub { $subject->use() };

          Then sub { has_failed(shift, qr/cannot re-use/i) };
        };
      };
    };

    # prove -v --lib t/example.t


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
