# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Parser.pm) perl(HTTP/Response.pm) perl(IO/Handle.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Socket.pm)
# END SourceDeps(oneline)
%define module_version 0.0.1
%define module_name Test-HTTP-MockServer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.1
Release: alt1
Summary: Implement a mock HTTP server for use in tests
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRUOSO/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
Sometimes, when writing a test, you don't have to oportunity to do
dependency injection of the type of transport used in a specific
API. Sometimes that code willl unequivocally always use actual HTTP
and the only control you have is over the host and port to which it
will connect.

This class offer a simple way to mock the service being called. It
does that by binding to a random port on localhost and allowing you to
inspect which port that was. Using a random port means that this can
be used by tests running in parallel on the same host.

The socket will be bound and listened on the main test process, such
that the lifetime of the connection is defined by the lifetime of the
test itself.

Since the socket will be already bound and listened to, the two
conntrol methods (start_mock_server and stop_mock_server) fork only
for the accept call, which means that it is safe to call start and
stop several times during the test in order to change the expectations
of the mocked code.

That allows you to easily configure the expectations of the mock
server across each step of your test case. On the other hand, it also
means that no state is shared between the code running in the mock
server and the test code.
%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/T*

%changelog
