%define module_name Test-JSON-Schema-Acceptance
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/BeforeRelease.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(ExtUtils/MakeMaker.pm) perl(Feature/Compat/Try.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(Git/Wrapper.pm) perl(JSON/MaybeXS.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Mojo/JSON.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(MooX/TypeTiny.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Test/Deep.pm) perl(Test/Fatal.pm) perl(Test/File/ShareDir.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(Test/Warnings.pm) perl(Test2/API.pm) perl(Test2/Suite.pm) perl(Test2/Todo.pm) perl(Test2/Tools/Compare.pm) perl(Text/ParseWords.pm) perl(Tie/Hash.pm) perl(Types/Common/Numeric.pm) perl(Types/Standard.pm)
BuildRequires: perl(constant.pm) perl(experimental.pm) perl(feature.pm) perl(if.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(namespace/clean.pm) perl(open.pm) perl(stable.pm) perl(strict.pm) perl(strictures.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.029
Release: alt1
Summary: Acceptance testing for JSON-Schema based validators like JSON::Schema
Group: Development/Perl
License: mit
URL: https://github.com/karenetheridge/Test-JSON-Schema-Acceptance

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
JSON Schema is an IETF draft (at time of writing) which allows you to define the structure of JSON.

The abstract from draft 4 of the specification:

=over 4
JSON Schema defines the media type "application/schema+json",
a JSON based format for defining the structure of JSON data.
JSON Schema provides a contract for what JSON data is required
for a given application and how to interact with it.
JSON Schema is intended to define validation, documentation,
hyperlink navigation, and interaction control of JSON data.
=back

JSON::Schema is a perl module created independantly of the specification, which aims to implement the json-schema specification.

This module allows other perl modules (for example JSON::Schema) to test that they are json-schema compliant, by running the tests from the official test suite, without having to manually convert them to perl tests.

You are unliekly to want this module, unless you are attempting to write a module which implements json-schema the specification, and want to test your compliance.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING README examples
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*

%changelog
