%define module_name Test-Mock-Object
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache2/RequestRec.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Sub/Identify.pm) perl(Sub/Name.pm) perl(Test/LeakTrace.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: Dead-simple mocking
Group: Development/Perl
License: artistic_2
URL: https://github.com/Ovid/test-mock-object

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Mock objects can be a controversial topic, but sometimes they're very useful.
However, mock objects in Perl often come in two flavors:

=over 4

=item * Incomplete mocks of existing modules

=item * Generic mocks with clumsy interfaces I can never remember

=back

This module is my attempt to make things dead-easy. Here's a simple mock object:

    my $mock = create_mock(
        package => 'Toy::Soldier',
        methods => {
            name   => 'Ovid',
            rank   => 'Private',
            serial => '123-456-789',
        }
    );

You can figure out what that does and it's easy. However, we have a lot more.

Note, that while `$mocked->isa($package)' will return true for the name
of the package you're mocking, but the package will be blessed into a
namespace similar to `MockMeAmadeus::$compact_package', where
`$compact_package' is the name of the blessed package, but with `::'
replaced with underscores, along with a prepended `_V$mock_number'. Thus,
mocking something into the `Foo::Bar' package would cause `ref' to return
something like `MockMeAmadeus::Foo_Bar_b1'.

If you need something more interesting for `isa', pass in your own:

    my $mock = create_mock(
        package => 'Toy::Soldier',
        methods => {
            name   => 'Ovid',
            rank   => 'Private',
            serial => '123-456-789',
            isa    => sub {
                my ( $self, $class ) = @_;
                return $class eq 'Toy::Soldier' || $class eq 'Toy';
            },
        }
    );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/T*

%changelog
