%define module_name Test-Mock-Simple
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A simple way to mock out parts of or a whole module.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TA/TANK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a simple way of overriding any number of methods for a given object/class.

Can be used directly in test (or any) files, but best practice (IMHO) is to
create a 'Mock' module and using it instead of directly using the module in any
tests. The goal is to write a test which passes whether Mocking is being used or
not. See TEST_MOCK_SIMPLE_DISABLE below.

The default behavior is to not allow adding methods that do not exist.  This
should stop mistyped method names when attempting to mock existing methods.
See allow_new_methods below to change this behavior.

Why another Mock module?  I needed something simple with no bells or whistles
that only overrode certain methods of a given module. It's more work, but there
aren't any conflicts.

This module can not do anything about BEGIN, END, or other special name code
blocks.  To changes these see B's (The Perl Compiler Backend) begin_av, end_av,
etc. methods.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/T*

%changelog
