Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: /usr/bin/xvfb-run
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-NeedsDisplay
Version:        1.07
Release:        alt2_40
Summary:        Ensure that tests needing a display have one
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Test-NeedsDisplay
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/Test-NeedsDisplay-%{version}.tar.gz
# Prevent from races by using free display numbers, bug #1248968,
# CPAN RT#106699
Patch0:         Test-NeedsDisplay-1.07-Use-non-conflicting-display-numbers.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/External.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# xorg-x11-server-Xvfb for xvfb-run program required by Makefile.PL
BuildRequires:  xorg-xvfb xvfb-run
# Run-time:
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(warnings.pm)
# Optional tests:
# Pod::Simple 3.07 not used
# Test::CPAN::Meta 0.12 not used
# Test::MinimumVersion 0.008 not used
# Test::Pod 1.26 not used
# xeyes for xeyes (will pull in xorg-x11-apps on older distros)
BuildRequires:  xeyes
Requires:       perl(File/Spec.pm) >= 0.800
Requires:       perl(Test/More.pm) >= 0.470

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(File.Spec\|Test.More\).pm)/d

%description
When testing GUI applications, sometimes applications or modules absolutely
insist on a display, even just to load a module without actually showing
any objects.

%prep
%setup -q -n Test-NeedsDisplay-%{version}
%patch0  -p1
# Remove bundled modules
rm -rf ./inc
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
