%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(IO/Socket/INET.pm) perl(Module/Build.pm) perl(Net/hostent.pm) perl(Socket.pm) perl(Test/Builder.pm) perl(Test/More.pm) perl(Test/Tester.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Test-Net-Connect
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Test::Builder based tests for network connectivity
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NI/NIKC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Test::Net::Connect tests => 3;

    connect_ok({ host => 'smtp.example.com', port => 25,
                 proto => 'tcp' }, 'Check tcp://smtp.example.com:25');

    # proto defaults to 'tcp', the test name can be omitted, and the
    # port can be appended to the host name
    connect_ok({ host => 'smtp.example.com:25' });

    connect_not_ok({ host => 'localhost:23' },
                   'Telnet connections should not be accepted locally');

Test::Net::Connect automatically exports `connect_ok()' and
`connect_not_ok()' to make it easier to test whether or not a network
connection can be made from this host to a port on another host using
TCP or UDP.

Test::Net::Connect uses Test::Builder, so plays nicely with Test::Simple,
Test::More, and other Test::Builder based modules.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
