%define module_name Test-OnlySome
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Prove.pm) perl(Best.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Config.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(Exporter/Renaming.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(Import/Into.pm) perl(Keyword/Declare.pm) perl(List/Util/MaybeXS.pm) perl(Module/Metadata.pm) perl(Pod/Markdown.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/Kit.pm) perl(Test/More.pm) perl(Test2/Tools/Compare.pm) perl(Try/Tiny.pm) perl(YAML.pm) perl(constant.pm) perl(parent.pm) perl(rlib.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001005
Release: alt1
Summary: Skip individual tests in a *.t file
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CX/CXW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In your test file (e.g., `t/01.t'):

    use Test::More tests => 2;
    use Test::OnlySome::RerunFailed;    # rerun only failed tests
    os ok(1, 'passes');     # "os" marks tests that might be skipped
    os ok(0, 'fails');

At the command line:

    $ osprove -lv
    ...
    ok 1 - passes
    not ok 2 - fails
    ...
    Result: FAIL

This creates `.onlysome.yml', which holds the test results from `t/01.t'.
Then, re-run:

    $ osprove -lv
    ...
    ok 1 # skip Test::OnlySome: you asked me to skip this
    not ok 2 - fails
    ...

Since test 1 passed the first time, it was skipped the second time.

You don't have to use the Test::OnlySome::RerunFailed manpage.  You can directly
use `Test::OnlySome', and you can decide in some other way which tests
you want to skip.

The argument to the os entry elsewhere in this document can be a statement or block, and it doesn't have to
be a the Test::More manpage test.  You can wrap long-running tests in functions,
and apply the os entry elsewhere in this document to those functions.

Please note that the os entry elsewhere in this document can take a `test_count' argument.  As discussed
in more detail below, please use a `test_count' of 1 for all tests run
under the Test::OnlySome::RerunFailed manpage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/T*
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
