Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(POE/Component/SSLify.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Enable TLS
%bcond_without perl_Test_POE_Client_TCP_enables_tls

Name:           perl-Test-POE-Client-TCP
Version:        1.26
Release:        alt2_21
Summary:        POE Component providing TCP client services for test cases
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Test-POE-Client-TCP
Source0:        https://cpan.metacpan.org/authors/id/B/BI/BINGOS/Test-POE-Client-TCP-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
# Original perl(POE) >= 1.28 rounded to 3 digits
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Filter/Line.pm)
BuildRequires:  perl(POE/Wheel/ReadWrite.pm)
BuildRequires:  perl(POE/Wheel/SocketFactory.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Socket.pm)
# Optional run-time:
# POE::Component::SSLify not used at tests
# Tests:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
# Pod::Coverage::TrustPod not used
BuildRequires:  perl(POE/Filter.pm)
BuildRequires:  perl(Test/More.pm)
# Test::Pod not used
# Test::Pod::Coverage not used
BuildRequires:  perl(Text/ParseWords.pm)
Requires:       perl(POE.pm) >= 1.280
%if %{with perl_Test_POE_Client_TCP_enables_tls}
Requires:     perl(POE/Component/SSLify.pm)
%endif
Requires:       perl(POE/Filter/Line.pm)
Requires:       perl(POE/Wheel/ReadWrite.pm)
Requires:       perl(POE/Wheel/SocketFactory.pm)
Requires:       perl(Socket.pm) >= 2.013

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(POE\|Socket\).pm)/d

%description
Test::POE::Client::TCP is a POE component that provides a TCP client
framework for inclusion in client component test cases, instead of having
to roll your own.

%prep
%setup -q -n Test-POE-Client-TCP-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset AUTHOR_TESTING
make test

%files
%doc --no-dereference LICENSE
%doc Changes Changes.old examples README
%{perl_vendor_privlib}/*

%changelog
