%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/MOP.pm) perl(Class/MOP/Class.pm) perl(Class/Struct.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/String.pm) perl(Moose.pm) perl(Moose/Meta/Role.pm) perl(Moose/Role.pm) perl(Scalar/Util/Reftype.pm) perl(Test/More.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Test-Pockito
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Inspired by Mockito, a library to build mock objects for test driven development
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EX/EXUSSUM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A mock object is a thing that imitates something else that may be hard to setup or can be brittle.  Examples of such are databases, network connections, and things deemed non trivial that may involve state.

The following is an overly complicated class that marries two people together, that takes two user ids and inserts that user1 is married to user2, and vice versa.  We should probably check to make sure they exist to make sure they aren't married already.

Our database object we wish to mock out may provide methods like, is_married( $user ), and marry($user1, $user2);


_package Love;

_sub new {
_    return bless {}, Love;
_}

_sub marry {
_    my $self  = shift;
_    my $user1 = shift;
_    my $user2 = shift;

_    my $db_object = $self->{'db_object'};

_    if (   $db_object->is_married($user1) == 0
__&& $db_object->is_married($user2) == 0 )
_    {
__$db_object->marry( $user1, $user2 );
__$db_object->marry( $user2, $user1 );
__return 1;
_    }
_    return 0;
_}

_package MyDbClass;

_sub is_married {
_    # do some complicated stuff
_}

_sub marry {
_    # do some other complicated stuff
_}

_#Our test can be

_use Test::Pockito;
_use Test::Simple;

_my $pocket  = Test::Pockito->new("MyNamespace");
_my $db_mock = $pocket->mock("MyDbClass");

_$pocket->when( $db_mock->is_married("bob") )->then(0);
_$pocket->when( $db_mock->is_married("alice") )->then(0);
_$pocket->when( $db_mock->marry( "alice", "bob" ) )->then();
_$pocket->when( $db_mock->marry( "bob",   "alice" ) )->then();

_my $target = Love->new();
_$target->{'db_object'} = $db_mock;

_ok( $target->marry( "bob", "alice" ) == 1, "single to married == success!" );

_ok( scalar keys %%{ $pocket->expected_calls } == 0,
_    "No extra cruft calls, huzzah!" );

A few things are going on here.

The $pocket object holds logs of interactions between objects you mock through it.  This offers the convenience of validating through one object, but if you wish to have two completely different mocks, one can create different Pockito objects.  The namespace passed along is a prefix to all packages created for the mock to avoid collisions.  In this case, a MyNamespace::Love package is created.  

The ->mock call is just like ->new except the package name is passed. It will inspect the package for all subs, and in the case of Moose, attributes to mimic.

$pocket->when( .... )->then( ... ) records many things.  It records in the ->is_married sub is called, with a parameter "bob".  When this combination occurs the first time, return 0.  One can queue up multiple calls with the same signature to have multiple results.

$pocket->{'warn'} tells Pockito to complain about calls that it doesn't expect.

Finally, a hash of calls that have yet to be executed are returned via expected_calls.  Since we called everything we expected, we can celebrate.  If is_married returned a random number, we could inspect the result of expected_calls and make a judgement call if the expectations were met.

There are some conveniences written in for default calls, partial mocks, outputting a formated report of what method calls have yet to be called, custom equality comparisons for parameters and bridges for package creation.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.TXT
%perl_vendor_privlib/T*

%changelog
