%define module_name Test-Ratchet
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Munge.pm) perl(Exporter/Easy.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Mocking helper that swaps out implementations automatically
Group: Development/Perl
License: mit
URL: https://github.com/Altreus/p5-Test-Ratchet

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AL/ALTREUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Testing sucks, especially when you have to deal with third-party code,
especially when you didn't have a choice about which third-party code you are
relying on.

This module solves one specific difficulty of doing so: when you have an atomic
operation that ends up running the same function multiple times with different
data.

An example you say? The rationale for writing this module was to test a module
that used the PATCH entry in the REST::Client manpage twice in the same function, but sending
different data to different endpoints (because Reasons). Since the function
being tested could not be subdivided *by* the test, it made sense to set up a
sequence of expectations before the test instead.

This module, then, simply exports the the ratchet entry elsewhere in this document function, which sets up
a queue of subrefs to handle a mocked function.

I'm sure it has other purposes too.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README CONTRIBUTING.md LICENSE
%perl_vendor_privlib/T*

%changelog
