# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Config.pm) perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-Run-Plugin-AlternateInterpreters
%define upstream_version 0.0125

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    A plugin
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(MRO/Compat.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Run/CmdLine.pm)
BuildRequires: perl(Test/Run/CmdLine/Trap/ProveApp.pm)
BuildRequires: perl(Test/Run/Core.pm)
BuildRequires: perl(Test/Trap.pm)
BuildRequires: perl(YAML/XS.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a the Test::Run::CmdLine manpage plugin that allows enabling
alternate interpreters. One can specify them by setting the
''HARNESS_ALT_INTRP_FILE'' environment variable to the path to a YAML
configuration file which lists the interpreters and their regular
expressions. A sample one is:

    ---
    - cmd: '/usr/bin/ruby'
      pattern: \.rb\z
      type: regex
    - cmd: '/usr/bin/python'
      pattern: \.py\z
      type: regex

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
