%define module_version 0.02
%define module_name Test-Script-Async
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AE.pm) perl(AnyEvent/Open3/Simple.pm) perl(Capture/Tiny.pm) perl(Config.pm) perl(Devel/Hide.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(Mojo/IOLoop.pm) perl(Mojo/Log.pm) perl(Mojo/Reactor.pm) perl(Mojo/Server/Daemon.pm) perl(Mojo/URL.pm) perl(Mojo/UserAgent.pm) perl(Mojolicious/Lite.pm) perl(Probe/Perl.pm) perl(Test/More.pm) perl(Test2.pm) perl(Test2/Suite.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Non-blocking friendly tests for scripts
Group: Development/Perl
License: perl
URL: http://perl.wdlabs.com/Test-Script-Async

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is a non-blocking friendly version of the Test::Script manpage.  It is useful when you have scripts
that you want to test against a the AnyEvent manpage or the Mojolicious manpage based services that are running
in the main test process.  The the AnyEvent manpage implementations that are known to work with this
module are pure perl, the EV manpage and the Event manpage.  Others may work, or may be added in the future.

This module will use the Mojo::IOLoop manpage if any the Mojo manpage modules are loaded.  The the Mojo manpage event loop
only works with the EV manpage if you want to use the AnyEvent manpage, so make sure that you include a `use EV'
line if you intend on using both the AnyEvent manpage and the Mojolicious manpage.

The interface is different from the Test::Script manpage for running scripts, in that it is object oriented.
The the script_runs entry elsewhere in this document function only tests that the script was able to run normally, and returns
an instance of the Test::Script::Async manpage which can be interrogated for things like the exit value
and output.

It uses the brand spanking new the Test::Stream manpage, which means that it is not (as of this writing)
compatible with the Test::More manpage and friends, though hopefully that will be rectified one day.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
