Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# noarch, but to avoid *.list files interfering with signature test
%global debug_package %{nil}

# Similarly, for package note feature
%undefine _package_note_file

# Store keys in a temp directory
%global gnupghome %(mktemp --directory)

Name:           perl-Test-Signature
Version:        1.11
Release:        alt2_35
Summary:        Automated SIGNATURE testing
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Test-Signature
Source0:        https://cpan.metacpan.org/modules/by-module/Test/Test-Signature-%{version}.tar.gz
# Audrey Tang's public key (3C3501A0), from the Module::Signature 0.61 distribution
Source1:        AUDREY2006.pub
# Petr Pisar's public key (4B528393E6A3B0DFB2EF3A6412C9C5C767C6FAA2)
Source2:        ppisar2011.pub
Patch0:         Test-Signature-1.11-Fix-building-on-Perl-without-.-in-INC.patch 
Patch1:         Test-Signature-1.11-Resign-patched-code.patch
BuildArch:      noarch
# Module Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gnupg2
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
# Dependencies of bundled Module::Install
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(ExtUtils/Manifest.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(FindBin.pm)
# Module Runtime
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Module/Signature.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Builder.pm)
BuildRequires:  perl(vars.pm)
# Test Suite
BuildRequires:  perl(Test/More.pm)
# Optional Tests
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(Test/Pod.pm)
# Dependencies
# Package just skips (or, optionally, fails) testing if Module::Signature not installed
Requires:       perl(Module/Signature.pm)
# Likewise, needs Socket to connect to keyserver
Requires:       perl(Socket.pm)
Source44: import.info

%description
Module::Signature allows you to verify that a distribution has not been
tampered with. Test::Signature lets that be tested as part of the
distribution's test suite.

%prep
%setup -q -n Test-Signature-%{version}

# Fix building on Perl without "." in @INC (CPAN RT#121760)
%patch0  -p1
# Required to pass tests after patching
%patch1  -p1

# Import upstream's GPG key so we don't need to fetch it from a keyserver
# when running the signature test
export GNUPGHOME=%{gnupghome}
gpg2 --import %{SOURCE1}
gpg2 --import %{SOURCE2}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
export GNUPGHOME=%{gnupghome}
make test

%files
%doc Changes README
%{perl_vendor_privlib}/Test/

%changelog
