%define _without_test 1
%define module_version 0.01
%define module_name Test-Struct
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension for testing for structural equivelence.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Y/YV/YVES/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Test::Struct is used for doing deep structural comparisons of two
objects. The module contains only one subrotuine which is intended
to be used as a mix-in with other more generic Test::Builder derived
modules like Test::More or Test::Simple. The code normally uses
Scalar::Util for inspecting the data, but it will also use additional
fine tuned comparison tools from Data::Dump::Streamer if they are
available.

=over 4

=item deep_eq($got,$expected,$name)

Does a deep level comparison of two objects. It traverses the two
structures in parallel checking as many attributes as it can for
differences. If the objects differ it will output a diagnostic
message containing a list of the differences it encountered before
it finished the comparison. Some types of mismatch prevent further
comparison so the list may not be exhaustive.

The intention of this routine is that it will pass the test only
if $got is functionally identical to $expected. However, at current
time there are some data types it does not handle properly, such as
CODE refs.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
