# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.000003
%define module_name Test-Subunits
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000003
Release: alt1
Summary: Extract subunit tests from within complex source code
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DC/DCONWAY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
*"Unit testing is right. Unit testing works. Unit testing clarifies.
   Unit testing, for lack of a better word, is good."*

...but unit testing can also be expensive. In particular, unit testing
requires that your code be composed from a large number of small
independently testable units (i.e. short subroutines). And, while
that's good software engineering, it can sometimes be bad performance
engineering.

Because that kind of highly decomposed then highly recomposed code also
requires a large number of internal subroutine calls, and a lot of
argument passing, either of which can reduce the performance of your
code to unacceptable levels.

When that happens, the usual solution is to "inline" the original units
of code: to create a single, larger, more complex subroutine that does
everything in one place and as fast as possible.

But that kind of subroutine is also much more difficult to test (if it
can be tested at all).

This module allows you to write fast-but-monolithic subroutines when you
need to, but still be able to test individual sections of that code
(known as "subunits") as if they were separate small-but-composable
subroutines.

To do this, you annotate parts of your monolithic code with special
comments. This module then uses those annotations to extract individual
chunks of your code which it compiles into separate subroutines, which
your test suite can then test independently.

In a sense, it's the exact opposite of inlining small subroutines into
your code. The module effectively "out-lines" predetermined fragments of
your code to create small subroutines that you can then test.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
