%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Class/DBI/Loader/Relationship.pm) perl(Class/Data/Inheritable.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers/Util.pm) perl(HTTP/Status.pm) perl(Maypole.pm) perl(Maypole/Application.pm) perl(Module/Build.pm) perl(NEXT.pm) perl(Test/More.pm) perl(Test/WWW/Mechanize.pm) perl(UNIVERSAL/require.pm) perl(URI.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.23
%define module_name Test-WWW-Mechanize-Maypole
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: Test::WWW::Mechanize for Maypole
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVEBAIRD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
By inheriting from the Test::WWW::Mechanize manpage, this module provides two key benefits 
over using the Maypole::CLI manpage in test scripts. First, it inherits a plethora of methods 
for testing web content. Second, cookies are handled transparently, allowing 
you to test applications that use cookie-based sessions and authentication. 

Testing web applications has always been a bit tricky, normally
starting a web server for your application and making real HTTP
requests to it. This module allows you to test the Maypole manpage web
applications but does not start a server or issue HTTP
requests. Instead, it passes the HTTP request parameters directly to
the Maypole manpage. Thus you do not need to use a real hostname:
"http://localhost/" will do.

This makes testing fast and easy. the Test::WWW::Mechanize manpage provides
functions for common web testing scenarios. For example:

  $mech->get_ok( $page );
  $mech->title_is( "Invoice Status", "Make sure we're on the invoice page" );
  $mech->content_contains( "David Baird", "My name somewhere" );
  $mech->content_like( qr/(cpan|perl)\.org/, "Link to perl.org or CPAN" );

This module supports cookies automatically.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
