%define module_name Test-WWW-Mechanize-Mojo
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Compress/Zlib.pm) perl(Cwd.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTML/Entities.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Mojolicious/Lite.pm) perl(Path/Tiny.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Test/WWW/Mechanize.pm) perl(base.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.21
Release: alt1
Summary: Test::WWW::Mechanize for Mojo / Mojolicious
Group: Development/Perl
License: perl
URL: http://web-cpan.berlios.de/modules/Test-WWW-Mechanize-Mojo/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHLOMIF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojo manpage is an MVC Web Application Framework.
the Test::WWW::Mechanize manpage is a subclass of the WWW::Mechanize manpage that incorporates
features for web application testing. The the Test::WWW::Mechanize::Mojo manpage
module meshes the two to allow easy testing of the Mojo manpage applications without
needing to starting up a web server.

Testing web applications has always been a bit tricky, normally
requiring starting a web server for your application and making real HTTP
requests to it. This module allows you to test the Mojo manpage web
applications but does not require a server or issue HTTP
requests. Instead, it passes the HTTP request object directly to
the Mojo manpage. Thus you do not need to use a real hostname:
"http://localhost/" will do. However, this is optional. The following
two lines of code do exactly the same thing:

  $mech->get_ok('/action');
  $mech->get_ok('http://localhost/action');

Links which do not begin with / or are not for localhost can be handled
as normal Web requests - this is handy if you have an external
single sign-on system. You must set allow_external to true for this:

  $mech->allow_external(1);

You can also test a remote server by setting the environment variable
MOJO_SERVER; for example:

  $ MOJO_SERVER=http://example.com/myapp prove -l t

will run the same tests on the application running at
http://example.com/myapp regardless of whether or not you specify
http:://localhost for Test::WWW::Mechanize::Mojo.

Furthermore, if you set MOJO_SERVER, the server will be regarded
as a remote server even if your links point to localhost. Thus, you
can use Test::WWW::Mechanize::Mojo to test your live webserver
running on your local machine, if you need to test aspects of your
deployment environment (for example, configuration options in an
http.conf file) instead of just the Mojo request handling.

This makes testing fast and easy. the Test::WWW::Mechanize manpage provides
functions for common web testing scenarios. For example:

  $mech->get_ok( $page );
  $mech->title_is( "Invoice Status", "Make sure we're on the invoice page" );
  $mech->content_contains( "Andy Lester", "My name somewhere" );
  $mech->content_like( qr/(cpan|perl)\.org/, "Link to perl.org or CPAN" );

This module supports cookies automatically.

To use this module you must pass it the name of the application. See
the SYNOPSIS above.

Note that Mojo has a special developing feature: the debug
screen. By default this module will treat responses which are the
debug screen as failures. If you actually want to test debug screens,
please use:

  $mmech->{catalyst_debug} = 1;

An alternative to this module is the Test::Mojo manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes.old-Catalyst.txt LICENSE Changes
%perl_vendor_privlib/T*

%changelog
