# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Archive/Zip.pm) perl(Devel/REPL.pm) perl(Devel/REPL/Plugin.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Test-WWW-Selenium
%define upstream_version 1.36

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_9

Summary:    Test applications using Selenium Remote Control
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Test/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(HTTP/Headers.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(IO/Socket.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Test/Builder.pm)
BuildRequires: perl(Test/Builder/Tester.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/Mock/LWP.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(URI/Escape.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildRequires: perl-libwww-perl
BuildArch:  noarch
Source44: import.info

%description
Selenium Remote Control (SRC) is a test tool that allows you to write
automated web application UI tests in any programming language against any
HTTP website using any mainstream JavaScript-enabled browser. SRC provides
a Selenium Server, which can automatically start/stop/control any supported
browser. It works by using Selenium Core, a pure-HTML+JS library that
performs automated tasks in JavaScript; the Selenium Server communicates
directly with the browser using AJAX (XmlHttpRequest).

http://www.openqa.org/selenium-rc/

This module sends commands directly to the Server using simple HTTP
GET/POST requests. Using this module together with the Selenium Server, you
can automatically control any supported browser.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*

%changelog
