%define module_name Test2-Plugin-FauxHomeDir
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(Test2/API.pm) perl(Test2/Mock.pm) perl(Test2/V0.pm) perl(if.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Setup a faux home directory for tests
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Test2::Plugin::FauxHomeDir

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module sets up a faux home directory for tests. The home directory 
is empty, and will be removed when the test completes.  This can be 
helpful when you are writing tests that may be reading from the real 
user configuration files, or if it writes output to the user home 
directory.

At the moment this module accomplishes this by setting the operating 
system appropriate environment variables. In the future, it may hook 
into some of the other methods used for determining home directories 
(such as `getpwuid' and friends).  There are many ways of getting 
around this faux module and getting the real home directory (especially
from C).  But if your code uses standard Perl interfaces then this 
plugin should fool your code okay.

This module sets the native environment variables for the home directory 
on your platform.  That means on Windows `USERPROFILE', `HOMEDRIVE' 
and `HOMEPATH' will be set, but `HOME' will not.  This is important 
because your testing environment should match as closely as possible 
what the actual environment will look like.

You should load this module as early as possible.

This systems are actively developed and tested:

=over 4

=item Linux

=item Strawberry Perl (Windows)

=item cygwin

=back

I expect that it should work on most other modern UNIX platforms.  It 
probably will not work on more esoteric systems like VMS or msys2.  
Patches to address this will be eagerly accepted.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
