# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(FindBin.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Text-ASCIIPipe
%define upstream_version 1.001000

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Helper for processing multiple text files in a stream (through a pipe, usually)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Text/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
A lot of the speed penalty of Perl when processing multiple smallish data
sets from/to text form in a shell loop consists of the repeated perl
compiler startup / script compilation, which accumulates when looping over
a set of files. This process can be sped up a lot by keeping the pipe alive
and streaming the whole file set through it once. This module helps you
with that. Of course, a pipe of several scripts parsing/producing text will
still be slower than a custom C program that does the job, but with this
trick of avoiding repeated script interpretation/compilation, the margin is
a lot smaller.

When dealing with ASCII-based text files (or UTF-8, if you please), there
are some control characters that just make sense for pushing several files
as a stream, separated by these characters. These are character codes 2
(STX, start of text), 3 (EOT, end of text) and 4 (ETX, end of
transmission). All this module does is provide a wrapper for inserting
these control characters for the sender and parsing them for the receiver.
Nothing fancy, really. I just got fed up writing the same loop over and
over again. It works with all textual data that does not contain control
characters below decimal code 5.

The process() function itself tries to employ a bit of smartness regarding
buffering of the output. Since the actual operation of multiple
ASCIIPipe-using programs in a, well, pipe, might conflict with the default
buffering of the output stream (STDOUT), process() disables buffering on
the output whenever it encounters the first STX. This mirrors the code this
module has been pulled from: It made sense there, enabling the last
consumer in the pipe to get the end of a file in time and act on that
information. This behaviour can be turned off by giving flush=>0 as
parameter.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%perl_vendor_privlib/*
/usr/bin/asciipipe_in
/usr/bin/asciipipe_out

%changelog
