# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(ExtUtils/MakeMaker.pm) perl(Regexp/Assemble.pm) zlib-devel
# END SourceDeps(oneline)
%define module_name Text-Darts
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt2
Summary: Perl interface to DARTS by Taku Kudoh
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DANKOGAI/%{module_name}-%{version}.tar.gz

%description
Darts, or Double-ARray Trie System is a C++ Template Library by Taku Kudoh.
This module makes use of Darts to implement global replace like below;

  $str = s{ (foo|bar|baz) }{ "<<$1>>" }msgex;

The problem with regexp is that it is slow with alterations.  Suppose
you want to anchor all words that appear in /usr/share/dict/words with
regexp.  It would be impractical with regexp.  This module makes it
practical.

Even if you are using perl 5.10 or better which does TRIE optimization
internally, you still have to compile the regexp everytime you run the
script.  So it is still more practical to use this module if your
match is exact -- containing no quantifier.

Since Version 0.05, the Text::Darts manpage also accepts a hash reference
instead of a code reference.  In such cases gsub behaves as follows.

  $str = s{ (foo|bar|baz) }{$replacement{$1}}msgx;

like `s///ge' vs `s///g', this is less flexible but faster.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
