%define module_name Text-Delimited-Marpa
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Const/Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Marpa/R2.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Tree.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Extract delimited text sequences from strings
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
the Text::Delimited::Marpa manpage provides a the Marpa::R2 manpage-based parser for extracting delimited text
sequences from strings. The text between the delimiters is stored as nodes in a tree managed by
the Tree manpage. The delimiters, and the text outside the delimiters, is not saved in the tree.

Nested strings with the same delimiters are saved as daughters of their enclosing strings' tree
nodes. As you can see from the output just above, this nesting process is repeated as many times as
the delimiters themselves are nested.

You can ignore the nested, delimited, strings by just processing the daughters of the tree's root
node.

This module is a companion to the Text::Balanced::Marpa manpage. The differences are discussed in the the FAQ entry elsewhere in this document
below.

See the the FAQ entry elsewhere in this document for various topics, including:

=over 4

=item o UFT8 handling

See t/utf8.t.

=item o Escaping delimiters within the text

See t/escapes.t.

=item o Options to make mismatched delimiters fatal errors

See t/escapes.t and t/perl.delimiters.

=item o Processing the tree-structured output

See scripts/traverse.pl.

=item o Emulating the Text::Xslate manpage's use of '<:' and ':>

See t/colons.t and t/percents.t.

=item o Skipping (leading) characters in the input string

See t/skip.prefix.t.

=item o Implementing hard-to-read text strings as delimiters

See t/silly.delimiters.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes Changelog.ini LICENSE
%perl_vendor_privlib/T*

%changelog
