# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(Ref/Util.pm) perl(Test2/V0.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define module_name Text-HumanComputerWords
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Split human and computer words in a naturalish manner
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Text::HumanComputerWords

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module extracts human and computer words from text.  This is useful for checking the validity of these words.  Human
words can be checked for spelling, while "computer" words like URLs can be validated by other means.  URLs for example
could be checked for 404s and module names could be checked against a module registry like CPAN.

The algorithm works like thus:

=over 4

=item 1. The text is split on whitespace into fragments `/\s/'

fragments could be either a single computer word like a URL or a module, or it could be one or more human words.
If a fragment doesn't contain any word characters then it is skipped entirely `/\w/'.

=item 2. If the fragment is recognized as a computer word we are done.

Computer words can be defined any way you want.  The `default_perl' method below is reasonable for Perl technical
documentation.

=item 3. Split the fragment into words using the Unicode word boundary `/\b{wb}/'

After the split words are identified as those containing word characters `/\w/'.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE author.yml README Changes
%perl_vendor_privlib/T*

%changelog
