%define module_name Text-Layout
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cairo.pm) perl(ExtUtils/MakeMaker.pm) perl(Font/TTF/Font.pm) perl(Font/TTF/Ttc.pm) perl(HarfBuzz/Shaper.pm) perl(Object/Pad.pm) perl(PDF/API2.pm) perl(Pango.pm) perl(Test/More.pm) perl(Text/ParseWords.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.045
Release: alt1
Summary: Pango style markup formatting
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JV/JV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Text::Layout provides methods for Pango style text formatting. Where
possible the methods have identical names and (near) identical
behaviour as their Pango counterparts.

See https://developer.gnome.org/pango/stable/pango-Layout-Objects.html.

The package uses Text::Layout::FontConfig to organize fonts by
description.

Example, using PDF::API2 integration:

    # Create a PDF document.
    my $pdf = PDF::API2->new;_# or PDF::Builder->new
    $pdf->mediabox( 595, 842 );_# A4, PDF units

    # Set up page and get the text context.
    my $page = $pdf->page;
    my $ctx  = $page->text;

    # Create a markup instance.
    my $layout = Text::Layout->new($pdf);

    $layout->set_font_description(Text::Layout::FontConfig->from_string("times 40"));
    $layout->set_markup( q{The <i><span foreground="red">quick</span> <span size="20"><b>brown</b></span></i> fox} );

    # Center text.
    $layout->set_width(595);_# width of A4 page
    $layout->set_alignment("center");

    # Render it.
    $layout->show( $x, $y, $ctx );

All PDF::API2 graphic and text methods can still be used, they won't
interfere with the layout methods.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/T*

%changelog
