# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Path/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Text-NSR
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt1
Summary: Read "newline separated records" (NSR) structured text files
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CL/CLIPLAND/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
There are a number of data exchange formats out there that strive to be structured in a way that is both,
easily and intuitively editable by humans and reliably parseable by machines. This module here adds yet another
structured file format, a file composed of "newline separated records".

The guiding principal here is that each line in a file represents a value. And that multiple lines form a
single record. Multiple records then are separated by one empty line. Exactly one empty line. A second empty
line will be interpreted as the first line of the next record. The only exception to this rule are leading or
trailing newlines on the "whole file" scope. They are considered "padding" and are dropped.

Values may contain newlines (line feed). In a raw NSR file, newlines are represented literal chars "\n" ("backslash"
plus "n"). After record-parsing, these chars are replaced by the newline char in the resulting data structure.

NSR files can be used to hold very simple human editable databases.

This module here helps with reading and parsing of such files.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/T*

%changelog
