%define module_version 0.05
%define module_name Text-PageLayout
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Distribute paragraphs onto pages, with headers and footers.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MO/MORITZ/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Text::PageLayout breaks up a list of paragraphs into pages. It supports
headers and footers, possibly varying by page number.

It operates under the assumption that all text blocks that are passed to
(header, footer, paragraphs, separator) are either the empty string, or
terminated by a newline. It also assumes that all those text blocks are
properly line-wrapped already.

The header and footer can either be strings, or subroutines that will be
called, and must return the string that is then used as a header or a footer.
In both cases, the string that is used as header or footer can be
post-processed with a custom callback `process_template'.

The layout of a result page is always the header first, then as many
paragraphs as fit on the page, separated by `separator', followed by
as many blank lines as necessary to fill the page (if `fillup_pages' is set,
which it is by default), followed by the footer.

If the naive layouting algorithm (take as many paragraphs as fit) leaves
more than `tolerance' empty fill lines, the `split_paragraph' callback is
called, which can attempt to split the paragraph into small chunks, which are
nicer to format.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
