# BEGIN SourceDeps(oneline):
BuildRequires: perl(LWP/Simple.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Text-Scraper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Structured data from (un)structured text
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MC/MCEWAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Template Tags are classed as *Leaves* or *Branches*. Like XML, Branches must 
have an associated closing tag, Leaves must not. By default, Leaf nodes return 
SCALARs and Branch nodes return ARRAYs of HASHes - each array element mapping 
to a matched sub-sequence. Blessing or filtering this data is left as an 
exercise for subclasses.

The default syntax is based on the XML preprocessor syntax:

    <?tmpl TYPE NAME [ATTRIBUTES] ?>
    
and for Branches:

    <?tmpl TYPE NAME [ATTRIBUTES] ?>  
        ...  
    <?tmpl end NAME ?>    

By default, Tags *must* be named and any closing tag *must* include the name of the 
opening tag it is closing. Attributes have the same syntax as XML attributes - 
but (similar to Perl regular expressions) can use any non-bracket punctuation character 
as quotation delimiters:

    <?tmpl var foo bar="baz" blah=/But dont "quote" me on that!/ ?> 

The only attribute acted on by the default tag classes is `regex' - used to refine how 
the Tag is translated into a regular-expression capture group:

    <?tmpl var naiveEmailAddress  regex="([\w\d\.]+\@[\w\d\.]+)"  ?>

This can be used to further filter the parsed data - similar to using grep:

    <?tmpl var onlyFoocomEmailAddresses regex="([\w\d\.]+@(?:foo\.com))" ?>

Each tag should create *only one* capture group - but it is fine to make the outer 
group non-capturing:

    <?tmpl var dateJustMonth regex="(?:\d+ (\S+) \d+)" ?>

*The above would capture only the month field in dates formated as* `02 July 1979'.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO Changes
%perl_vendor_privlib/T*

%changelog
