Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	OO interface for spell-checking a block of text 
Name:		perl-Text-SpellChecker
Version:	0.14
Release:	alt2_34
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Text-SpellChecker
Source0:	https://cpan.metacpan.org/modules/by-module/Text/Text-SpellChecker-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(MIME/Base64.pm)
BuildRequires:	perl(Storable.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Text/Hunspell.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
%if 0%{?fedora} > 23 || 0%{?rhel} > 7
BuildRequires:	glibc-locales
%endif
BuildRequires:	hunspell-en
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(utf8.pm)
# Optional Tests
BuildRequires:	perl(Test/Pod.pm)
%if 0%{?fedora:1} && 0%{?fedora} < 39
BuildRequires:	perl(Text/Aspell.pm), aspell-en
%endif
# Dependencies
# hunspell is the preferred spell checking backend in Fedora
Requires:	perl(Text/Hunspell.pm)
Source44: import.info

%description
This module is a thin layer above Text::Hunspell and allows one to spellcheck
a body of text. Whereas Text::Hunspell deals with words, Text::Spellchecker
deals with blocks of text. For instance, we provide methods for iterating
through the text, serializing the object (thus remembering where we left off),
and highlighting the current misspelled word within the text.

%prep
%setup -q -n Text-SpellChecker-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
LANG=en_US make test TEST_VERBOSE=1

%files
%doc Changes README
%{perl_vendor_privlib}/Text/

%changelog
