%define module_version 0.06
%define module_name Text-Spintax
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Parse/Lex.pm) perl(Test/Kwalitee/Extra.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: A parser and renderer for spintax formatted text.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DALEEVANS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Text::Spintax implements a parser and renderer for spintax formatted text.  Spintax is a commonly used method for
generating "randomized" text.  For example,

    This {is|was} a test

would be rendered as

    * This is a test
    * This was a test

Spintax can be nested indefinitely, for example:

    This is nested {{very|quite} deeply|deep}.

would be rendered as

    * This is nested very deeply.
    * This is nested quite deeply.
    * This is nested deep.

The number of possible combinations is easy to calculate, but the proportion of renders has two options.  The initial Text::Spintax::RenderNode has weight 1 for all nodes, meaning that for the previous example the probabilities of each render would be

    25%% This is nested very deeply.
    25%% This is nested quite deeply.
    50%% This is nested deep.

If you want every possible outcome to be equally likely, then call equal_path_weight on the Text::Spintax::RenderNode object and you'll get this outcome:

    33%% This is nested very deeply.
    33%% This is nested quite deeply.
    33%% This is nested deep.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README examples
%perl_vendor_privlib/T*

%changelog
