%define module_name Text-Table-ASV
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Generate TSV
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Text-Table-ASV

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a single function, `table', which formats a
two-dimensional array of data as ASV. This is basically a way to generate ASV
using the same interface as that of the Text::Table::Tiny manpage (v0.03) or
the Text::Table::Org manpage.

ASV (ASCII separated values, also sometimes DEL a.k.a. Delimited ASCII) is a
format similar to TSV (tab separated values). Instead of Tab character ("\t") as
the field separator, ASV uses "\x1f" (ASCII Unit Separator character) and
instead of newline ("\n") as the record separator, ASV uses "\x1e" (ASCII Record
Separator). There is currently no quoting or escaping mechanism provided.
"\x1c", "\x1d", "\x1e", and "\x1f" characters in cell will be replaced by
spaces.

The example shown in the SYNOPSIS generates the following table (the record
separator and unit separator are shown using "\x1f" and "\x1f" respectively):

 Name\x1fRank\x1fSerial\x1ealice\x1fpvt\x1f123456\x1ebob\x1fcpl\x1f98765321\x1ecarol\x1fbrig gen\x1f8745

=for Pod::Coverage ^(max)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
