%define module_name Text-Tree-Indented
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Ref/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: render a tree data structure in the classic indented view
Group: Development/Perl
License: perl
URL: https://github.com/neilb/Text-Tree-Indented

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEILB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a single function, `generate_tree',
which takes a perl data structure and renders it into
an indented tree view.

Note: the design of this module is still very much in flux,
so the data structure and other aspects made change from release
to release.

The tree data is passed as an arrayref.
A string in the arrayref represents a node in the tree;
if it's followed by an arrayref, that's a subtree.
So let's say the root of your tree is Fruit,
and it has three children, Apples, Bananas, and Oranges,
then the data would look like this:

 my $tree = ['Fruit', ['Apples', 'Bananas', 'Oranges'] ];

This results in the following tree:

 Fruit
   .i'.ieApples
   .i'.ieBananas
   .ii.ieOranges

Now you want to add in Red Bananas and Williams Bananas,
so your data becomes:

 my $tree = ['Fruit', ['Apples', 'Bananas', ['Red', 'Williams'], 'Oranges'] ];

And now the tree looks like this:

 Fruit
   .i'.ieApples
   .i'.ieBananas
   .i'   .i'.ieRed
   .i'   .ii.ieWilliams
   .ii.ieOranges

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/T*

%changelog
