%define module_name Text-Treesitter
# BEGIN SourceDeps(oneline):
BuildRequires: libtree-sitter-devel perl(Encode.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/CppGuess.pm) perl(File/Slurper.pm) perl(JSON/MaybeUTF8.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Build/Using/PkgConfig.pm) perl(Object/Pad.pm) perl(Syntax/Keyword/Match.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Perl binding for F<tree-sitter>
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz

%description
This module provides several classes and utilities that wrap the
tree-sitter parser library. A toplevel class is provided by this module
which wraps the functionallity of several other classes, which are also
available directly in the following modules:

=over 4

=item *

the Text::Treesitter::Language manpage - represents a tree-sitter language grammar

=item *

the Text::Treesitter::Node manpage - an element of a tree-sitter parse result

=item *

the Text::Treesitter::Parser manpage - parse some input text according to a tree-sitter grammar

=item *

the Text::Treesitter::Query manpage - represents a set of tree-sitter query patterns

=item *

the Text::Treesitter::QueryCursor manpage - stores the result of a tree-sitter node query

=item *

the Text::Treesitter::QueryMatch manpage - stores the result of a tree-sitter query pattern match

=item *

the Text::Treesitter::Tree manpage - holds the result of a tree-sitter parse operation

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes examples
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
