%define module_name Text-WagnerFischer-Amharic
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build.pm) perl(Regexp/Ethiopic.pm) perl(Text/WagnerFischer.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: The Wagner-Fischer Algorithm for Amharic.
Group: Development/Perl
License: perl
URL: https://github.com/dyacob/Text-WagnerFischer-Amharic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DY/DYACOB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements the Wagner-Fischer edit distance algorithm for
Ethiopic script under Amharic Amharic character classes.

The edit distance is a measure of the degree of proximity between two strings,
based on "edits". Each type of edit is given its own cost (weight).  In
additional to the three initial Wagner-Fischer weights, the
Amharic weight function recognizes 7 additional mismatch types:

_    / a: x = y           (cost for letter match)
 w(x,y) =  |  b: x = - or y = -  (cost for insertion/deletion operation)
_   |  c: x != y          (cost for letter mismatch)
           |  x =~ [#y#] and
           |    d: x =~ [=y=]                  (cost of decayed labiovelar)
           |    e: form(x) > 7 || form(y) > 7  (cost of labiovelar mismatch)
           |    f: else                        (cost of wrong form)
           |  form(x) == form(y) and
           |    g: x =~ [=y=]                  (cost of grapheme mismatch)
           |    h: x is a shift-slip of y      (cost of shift key mismatch)
           |    i: else                        (cost of wrong base)
           \  j: x =~ [=y=]  (cost of wrong grapheme and form, right phoneme)

These costs are given through an array reference as an option first argument
of the `distance' subroutine (see SYNOPSIS).

When two strings have distance 0, they are the same.
Note that the distance is calculated to reach the _minimum_ cost, i.e.
choosing the most economic operation for each edit.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes Changes.md SECURITY.md README.md LICENSE CONTRIBUTING.md examples
%perl_vendor_privlib/T*

%changelog
