Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Text-WordDiff
Version:        0.09
Release:        alt2_21
Summary:        Track changes between documents
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/Text-WordDiff
Source0:        https://cpan.metacpan.org/authors/id/T/TI/TIMK/Text-WordDiff-%{version}.tar.gz
Patch0:         Text-WordDiff-0.08-uselib.patch
BuildArch:      noarch
# Module Build
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Module/Build.pm)
# Module Runtime
BuildRequires:  perl(Algorithm/Diff.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(HTML/Entities.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Term/ANSIColor.pm)
BuildRequires:  perl(vars.pm)
# Test Suite
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Test/More.pm)
# Runtime
BuildRequires:  perl(Test/Pod.pm)
Requires:       perl(Algorithm/Diff.pm) >= 1.190

# Filter under-specified dependency

Source44: import.info
%filter_from_requires /^perl(Algorithm.Diff.pm)/d

%description
This module is a variation on the lovely Text::Diff module. Rather than
generating traditional line-oriented diffs, however, it generates word-
oriented diffs. This can be useful for tracking changes in narrative
documents or documents with very long lines. To diff source code, one is
still best off using Text::Diff. But if you want to see how a short
story changed from one version to the next, this module will do the job
very nicely.

%prep
%setup -q -n Text-WordDiff-%{version}

# Don't try to use upstream's personal modules
%patch0 

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT

%check
./Build test

%files
%doc Changes README.md
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/Text/

%changelog
