# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Text-Wrap-NoStrip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Line wrapping without stripping the whitespace
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Text-Wrap-NoStrip

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NOTE: Early implementaiton, no tab handling.

This module provides `wrap()' variant that does not strip the whitespaces, to
make unfolding easier and capable of returning the original text. Contrast:

 # original $text
 longwordlongwordlongword word   word   word word

 # wrapped by Text::Wrap::wrap('', 'x', $text), with added quotes
 # 123456789012
 "longwordlongw"
 "xordlongword"
 "xword   word"
 "xword word"

 # wrapped by Text::Wrapp::NoStrip::wrap('', ' ', $text)
 "longwordlongw"
 "xordlongword"
 "x word   word"
 "x   word word"

To get back the original $text, you can do:

 ($text = $wrapped) =~ s/\nx//g;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
