# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name TextDoc-Examples
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: A collection of various examples of word-processor text document files
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/TextDoc-Examples

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution contains, in its share directory, a collection of various
word-processor text document files, usually for testing or benchmarking
purposes:

=over

=item * empty

An empty text document. A4 page size.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/empty%%2Eodt">share/empty.odt</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/empty%%2Edocx">share/empty.docx</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/empty%%2Epdf">share/empty.pdf</a><br />

=end html


=item * 1000word-2page_a4

A document containing 1,000 placeholder words, 2 A4 pages with normal margins,
minimum formatting.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/1000word%%2D2page_a4%%2Eodt">share/1000word-2page_a4.odt</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/1000word%%2D2page_a4%%2Edocx">share/1000word-2page_a4.docx</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/1000word%%2D2page_a4%%2Epdf">share/1000word-2page_a4.pdf</a><br />

=end html


=item * 10000word-17page_a4

A document containing 10,000 placeholder words, 17 A4 pages with normal margins,
minimum formatting.

=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/10000word%%2D17page_a4%%2Eodt">share/10000word-17page_a4.odt</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/10000word%%2D17page_a4%%2Edocx">share/10000word-17page_a4.docx</a><br />

=end html


=begin html

<a href="https://st.aticpan.org/source/PERLANCAR/TextDoc-Examples-0.001/share/10000word%%2D17page_a4%%2Epdf">share/10000word-17page_a4.pdf</a><br />

=end html


=item * 100000word-163page_a4

A document containing 100,000 placeholder words, 163 A4 pages with nor...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*

%changelog
