%define module_name Thread-Bless
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(forks.pm) perl(forks/shared.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: make blessed objects thread-aware
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*** A note of CAUTION ***

 This module only functions on Perl versions 5.8.0 and later.
 And then only when threads are enabled with -Dusethreads.  It
 is of no use with any version of Perl before 5.8.0 or without
 threads enabled.

                  *************************

This module adds two features to threads that are sorely missed by some.

The first feature is that the DESTROY method is called only on the object if
the object is destroyed in the thread it was created in.  This feature is
automatically activated when Thread::Bless is used.

The second feature is that an optional fixup method is called on the object
(automatically by Thread::Bless) just after the object is cloned (automatically
by Perl) when a thread is started.  This is needed if the object contains
(references to) data structures that are not automatically handled by Perl.

Both features can be switched on/off seperately at compile or runtime to
provide the utmost flexibility.

For external modules that need to be thread aware but aren't yet (most notably
the ones that cannot handle having DESTROY called when cloned versions are
destroyed in threads), you can also activate Thread::Bless on them.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGELOG TODO
%perl_vendor_privlib/T*

%changelog
